implementation module GameLibrary

import StdEnv, StdIO
import StdGameDef, StdGame, StdGSt
import StdProcess


OBJ_AUTOINIT  :==  0



defaultGame :: .(Game DefaultGameState) [.GameAttribute DefaultGameState] !*World -> .World
defaultGame gamedef options world
    # world = startGame gamedef (defaultInitialGameState gamedef.levels)
                     (options ++ [ScreenSize {w=640,h=480}, ColorDepth 8]) world
    = world

::  DefaultGameState
    = { curlevel    :: Int
      , maxlevel    :: Int
      , quit        :: Bool

      }

defaultInitialGameState levels = { curlevel = 0
                                 , maxlevel = length levels
                                 , quit = False
                                 
                                 }


defaultGameDef :: [Level (GSt DefaultGameState)] -> (Game DefaultGameState)
defaultGameDef levels =
    { levels = levels
    , quitlevel = accGSt quitFunction
    , nextlevel = accGSt nextLevelFunction
    , textitems = accGSt textItemsFunction
    }


/* if the quit function returns true, the game engine quit the level */

quitFunction :: DefaultGameState -> (Bool, DefaultGameState)
quitFunction gst
    = (gst.quit, {gst & quit = False})


/* quit the level */

quitlevel (state, r) gs
    #   gs = appGSt setQuit gs
    =   ((state, r), gs)
where
    setQuit :: DefaultGameState -> DefaultGameState
    setQuit gst = {gst & quit = True}


/* function that returns the next level to run, 0 = end game */

nextLevelFunction :: DefaultGameState -> (Int, DefaultGameState)
nextLevelFunction gst =: {curlevel, maxlevel}
    = (nextLevel, {gst & curlevel = nextLevel})
where
    nextLevel = if (curlevel + 1 > maxlevel) 0 (curlevel + 1)


/* function that returns text to be displayed */

textItemsFunction :: DefaultGameState -> ([GameText], DefaultGameState)
textItemsFunction gst
    = ([], gst)

defaultGameLevel :: !(Maybe .Colour) ![.Layer] !.BoundMap !.[GameObject .a] -> .Level .a
defaultGameLevel fillcolor layers boundmap objects
    = { blankScreen
      & boundmap     = boundmap
      , layers       = layers
      , objects      = objects
      , leveloptions = { blankScreen.leveloptions
                       & fillbackground = fillcolor
                       , debugscroll = True
                       }
      }

emptyMap :: BoundMap
emptyMap = { map = [{0}]
           , blocksize = {w = 10000, h = 10000}
           , objstart  = 1
           , startobjx = 1
           , startobjy = 1
           }

defaultBoundMap :: !Size !Size ![(Point2, Int)] -> BoundMap
defaultBoundMap blocksize mapsize objinst
    = { emptyMap
      & map = [ListToArray [(f x y objinst) \\ x <- [1..mapsize.w]] \\ y <- [1..mapsize.h]]
      , blocksize = blocksize
      }
where
    f x y [] = 0
    f x y [(p, i):xs]
        | (p.x == x) && (p.y == y) = i * 256    // shl 8
        | otherwise                = f x y xs

ListToArray :: ![Int] -> {#Int}
ListToArray xs = {x \\ x <- xs}

ArrayToList :: !{#Int} -> [Int]
ArrayToList xs = [x \\ x <-: xs]

/*
newObject :: ObjectType Size [Sprite] (GameObjectRec -> GameObjectRec) -> (GameObject (GSt a))
newObject objtype size spritelist initfun
  = { defaultGameObject objtype size Void
    & sprites = spritelist
    , init    = (newinit size Void)
    }
where
    newinit size state subtype pos time gs
        # (objrec, gs) = defaultObjectRec subtype pos size time gs
        # objrec = initfun objrec
        = {objectstate = state, objectrec = objrec, gamestate = gs}
*/
